within Buildings.Fluid.Storage.Examples;
model StratifiedLoadingUnloading "Test model for stratified tank"
  extends Modelica.Icons.Example;
  import Buildings;

 package Medium = Buildings.Media.ConstantPropertyLiquidWater "Medium model";
 constant Integer nSeg = 7 "Number of segments in tank";

 parameter Modelica.SIunits.MassFlowRate m_flow_nominal= 1*1000/3600/4;

  Buildings.Fluid.Sources.Boundary_pT sou_1(
    p=300000 + 5000,
    T=273.15 + 40,
    redeclare package Medium = Medium,
    use_T_in=false,
    nPorts=2)             annotation (Placement(transformation(extent={{-100,-20},
            {-80,0}},  rotation=0)));
  Sources.MassFlowSource_T sin_1(
    redeclare package Medium = Medium,
    T=273.15 + 20,
    m_flow=-0.028,
    use_m_flow_in=true,
    nPorts=1)      annotation (Placement(transformation(extent={{78,-2},{58,18}},
                     rotation=0)));
  Buildings.Fluid.Storage.StratifiedEnhanced tanEnh(
    redeclare package Medium = Medium,
    hTan=3,
    dIns=0.3,
    VTan=0.1,
    nSeg=nSeg,
    show_T=true,
    m_flow_nominal=m_flow_nominal) "Tank"
                               annotation (Placement(transformation(extent={{-30,-2},
            {-10,18}},rotation=0)));

  inner Modelica.Fluid.System system
    annotation (Placement(transformation(extent={{-80,-80},{-60,-60}})));
  Sources.MassFlowSource_T sin_2(
    redeclare package Medium = Medium,
    T=273.15 + 20,
    m_flow=-0.028,
    use_m_flow_in=true,
    nPorts=1)      annotation (Placement(transformation(extent={{78,-40},{58,-20}},
                     rotation=0)));
  Buildings.Fluid.Storage.Stratified tan(
    redeclare package Medium = Medium,
    hTan=3,
    dIns=0.3,
    VTan=0.1,
    nSeg=nSeg,
    show_T=true,
    m_flow_nominal=m_flow_nominal) "Tank"
                               annotation (Placement(transformation(extent={{-26,-40},
            {-6,-20}},rotation=0)));

  Modelica.Blocks.Sources.Pulse pulse(
    amplitude=2*m_flow_nominal,
    offset=-m_flow_nominal,
    period=7200)
    annotation (Placement(transformation(extent={{20,80},{40,100}})));
  Buildings.Fluid.Sensors.EnthalpyFlowRate HIn_flow(redeclare package Medium =
        Medium, m_flow_nominal=m_flow_nominal) "Enthalpy flow rate"
                                     annotation (Placement(transformation(
          extent={{-60,-38},{-44,-22}},
                                   rotation=0)));
  Buildings.Fluid.Sensors.EnthalpyFlowRate HOut_flow(redeclare package Medium
      = Medium, m_flow_nominal=m_flow_nominal) "Enthalpy flow rate"
                                     annotation (Placement(transformation(
          extent={{22,-38},{38,-22}},
                                   rotation=0)));
  Buildings.Fluid.Sensors.EnthalpyFlowRate HInEnh_flow(redeclare package Medium
      = Medium, m_flow_nominal=m_flow_nominal) "Enthalpy flow rate"
                                     annotation (Placement(transformation(
          extent={{-60,0},{-44,16}},
                                   rotation=0)));
  Buildings.Fluid.Sensors.EnthalpyFlowRate HOutEnh_flow(redeclare package
      Medium = Medium, m_flow_nominal=m_flow_nominal) "Enthalpy flow rate"
                                     annotation (Placement(transformation(
          extent={{2,0},{18,16}},  rotation=0)));
  Modelica.Blocks.Math.Add add(k2=-1) annotation (Placement(transformation(
          extent={{20,40},{40,60}},   rotation=0)));
  Modelica.Blocks.Continuous.Integrator dHTanEnh
    "Difference in enthalpy (should be zero at steady-state)"
    annotation (Placement(transformation(extent={{60,40},{80,60}},   rotation=0)));
  Modelica.Blocks.Math.Add add1(
                               k2=-1) annotation (Placement(transformation(
          extent={{20,-80},{40,-60}}, rotation=0)));
  Modelica.Blocks.Continuous.Integrator dHTan
    "Difference in enthalpy (should be zero at steady-state)"
    annotation (Placement(transformation(extent={{60,-80},{80,-60}}, rotation=0)));
equation

  connect(sou_1.ports[1], HIn_flow.port_a) annotation (Line(
      points={{-80,-8},{-70,-8},{-70,-30},{-60,-30}},
      color={0,127,255},
      smooth=Smooth.None));
  connect(HIn_flow.port_b, tan.port_a) annotation (Line(
      points={{-44,-30},{-26,-30}},
      color={0,127,255},
      smooth=Smooth.None));
  connect(tan.port_b, HOut_flow.port_a) annotation (Line(
      points={{-6,-30},{22,-30}},
      color={0,127,255},
      smooth=Smooth.None));
  connect(HOut_flow.port_b, sin_2.ports[1]) annotation (Line(
      points={{38,-30},{58,-30}},
      color={0,127,255},
      smooth=Smooth.None));
  connect(sou_1.ports[2], HInEnh_flow.port_a) annotation (Line(
      points={{-80,-12},{-76,-12},{-76,-6},{-72,-6},{-72,8},{-60,8}},
      color={0,127,255},
      smooth=Smooth.None));
  connect(HInEnh_flow.port_b, tanEnh.port_a) annotation (Line(
      points={{-44,8},{-30,8}},
      color={0,127,255},
      smooth=Smooth.None));
  connect(tanEnh.port_b, HOutEnh_flow.port_a) annotation (Line(
      points={{-10,8},{2,8}},
      color={0,127,255},
      smooth=Smooth.None));
  connect(HOutEnh_flow.port_b, sin_1.ports[1]) annotation (Line(
      points={{18,8},{58,8}},
      color={0,127,255},
      smooth=Smooth.None));
  connect(HInEnh_flow.H_flow, add.u1) annotation (Line(
      points={{-52,16.8},{-52,56},{18,56}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(HOutEnh_flow.H_flow, add.u2) annotation (Line(
      points={{10,16.8},{10,44},{18,44}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(add.y, dHTanEnh.u) annotation (Line(
      points={{41,50},{58,50}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(HIn_flow.H_flow, add1.u1) annotation (Line(
      points={{-52,-21.2},{-52,-14},{-34,-14},{-34,-64},{18,-64}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(HOut_flow.H_flow, add1.u2) annotation (Line(
      points={{30,-21.2},{30,-16},{6,-16},{6,-76},{18,-76}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(add1.y, dHTan.u) annotation (Line(
      points={{41,-70},{58,-70}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(pulse.y, sin_1.m_flow_in) annotation (Line(
      points={{41,90},{92,90},{92,16},{78,16}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(pulse.y, sin_2.m_flow_in) annotation (Line(
      points={{41,90},{90,90},{90,-22},{78,-22}},
      color={0,0,127},
      smooth=Smooth.None));
  annotation(Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
            {100,100}})),
                      __Dymola_Commands(file="modelica://Buildings/Resources/Scripts/Dymola/Fluid/Storage/Examples/StratifiedLoadingUnloading.mos"
        "Simulate and plot"),
    Documentation(info="<html>
This test model compares two tank models. The only difference between
the two tank models is that one uses the third order upwind discretization
scheme that reduces numerical diffusion that is induced when connecting 
volumes in series.
</html>"),
    experiment(StopTime=14400));
end StratifiedLoadingUnloading;
